//FloorMagnetRecess.scad
//Module to make one recess for one magnet;

//I've decided that an elegant way 
//to attach the battery case 
//to the UNO case is to use a strong magnet;
//Specifically: Jaycar LM1622;
//Its diameter is 10mm, and its height is 3mm;
//I will make a hole 11mm in diameter 
//and 2mm deep in the top of FloorOne 
//and in the bottom of FloorTwo 
//to house the magnet;
//The magnet will be concealed in 
//this hole between the floors;
//I'll use a dab of adhesive to prevent rattles;

//This module provides a small cylinder 
//that will make the recess when used 
//in an appropriate difference() command; 

//On output from this module, the cylinder 
//is centered about the Z axis and the XY plane;

//Any further adjustment of orientation
//and/or position
//must be done by the calling module;

include <UNO_Dimensions.scad>;

module FloorMagnetRecess()
{

echo("Begin FloorMagnetRecess");
    
cylinder(h=2*MagnetHoleHeight,
    d=MagnetHolePhi, center=true, $fn=32);
}

//
